/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.domain;

import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.event.InitialDDETimeoutEvent;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DistributedDomain;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.config.AnalysisDomainData;
import com.ibm.hwmca.fw.pa.config.DistributedADData;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.util.CallbackTimerTask;
import com.ibm.hwmca.fw.pa.util.CallbackTimerTaskInterface;
import com.ibm.hwmca.fw.pa.util.LockAcquisitionException;
import com.ibm.hwmca.fw.pa.util.LockHeldException;
import com.ibm.hwmca.fw.pa.util.PAPublication;
import com.ibm.hwmca.fw.remres.ReservationManager;
import com.ibm.hwmca.fw.remres.ReservationManagerEvent;
import com.ibm.hwmca.fw.remres.ReservationManagerListener;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.MessageId;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.PartitionedMessage;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityStateEvent;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityStateListener;
import com.ibm.hwmca.xfw.pa.domain.AnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.AnalysisDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.ProblemDataSyncThread;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class DistributedAnalysisDomain
extends DistributedDomain
implements AnalysisDomain,
RemoteSystemStateListener,
RemoteEntityStateListener,
CallbackTimerTaskInterface,
ReservationManagerListener {
    private static final String TRACE_MASKT = "XPADSADT";
    private static final String TRACE_MASKF = "XPADSADF";
    private static final String TRACE_MASKD = "XPADSADD";
    protected DistributedADData dadData = null;
    protected ProblemAnalysisEventManager evtMgr = null;
    protected Set realInstanceSet = new HashSet();
    private boolean handleRSSEvent = false;
    protected Set rmsSet = new HashSet();
    private boolean handleRESEvent = false;
    private PASystem primaryConsole = null;
    protected static ConsoleSystem localConsole = null;
    protected boolean performingSynchronization = false;
    protected Object synchDataLock = new Object();
    protected Map synchDataMap = new HashMap();
    protected int synchDelay = 5;
    protected int problemDataSynchDelay = 5;
    protected CallbackTimerTask synchTimerTask = null;
    protected static final String PART_DAD_WHOS_PRIME = "PART_DAD_WHOS_PRIME";
    protected static final String PART_DAD_PRIME_INFO = "PART_DAD_PRIME_INFO";
    protected static final String PART_DAD_PRIME_UPDATE = "PART_DAD_PRIME_UPDATE";
    protected static final String PART_DAD_ARBITRATE_REQUEST = "PART_DAD_ARBITRATE_REQUEST";
    protected static final String PART_DAD_ARBITRATE_COMMAND = "PART_DAD_ARBITRATE_COMMAND";
    public static final String PART_DAD_PROB_PREFIX = "PART_DAD_PROB_";
    public static final String PART_DAD_PROB_SVC_AUTH = "PART_DAD_PROB_SVC_AUTH";
    public static final String PART_DAD_PROB_SVC_DECL = "PART_DAD_PROB_SVC_DECL";
    public static final String PART_DAD_PROB_SVC_MAN = "PART_DAD_PROB_SVC_MAN";
    public static final String PART_DAD_PROB_CLOSE = "PART_DAD_PROB_CLOSE";
    protected static final String UNKNOWN_PRIMARY = "0-0/0";
    protected int initialWait = 5;

    public DistributedAnalysisDomain() {
    }

    public DistributedAnalysisDomain(DomainIdentifier did) {
        super(did);
    }

    public Set buildDomainInstances(AnalysisDomainData adData, ProblemAnalysisEventManager evtMgr) {
        RemoteSystemManager rsm;
        Trace.trace(TRACE_MASKD, "--> buildDomainInstances");
        this.dadData = (DistributedADData)adData;
        this.evtMgr = evtMgr;
        if (localConsole == null) {
            ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
            if (cad != null) {
                localConsole = cad.getConsoleSystem();
                Trace.trace(TRACE_MASKT, "Local console = " + localConsole.getMTMS());
            } else {
                Trace.trace(TRACE_MASKT, "Couldn't get ConsoleSystem reference");
            }
        }
        if ((rsm = RemoteSystemManager.getRemoteSystemManager()) != null) {
            rsm.addRemoteSystemStateListener(this);
        }
        super.buildDomainInstances();
        Trace.trace(TRACE_MASKD, "<-- buildDomainInstances");
        return this.realInstanceSet;
    }

    protected Set instantiateDomains() {
        Trace.trace(TRACE_MASKD, "domain set size=" + this.realInstanceSet.size());
        Iterator realIter = this.realInstanceSet.iterator();
        while (realIter.hasNext()) {
            this.builderSetup((DistributedAnalysisDomain)realIter.next());
        }
        this.handleRSSEvent = true;
        return this.realInstanceSet;
    }

    protected void builderSetup(DistributedAnalysisDomain realDad) {
        realDad.dadData = this.dadData;
        realDad.evtMgr = this.evtMgr;
    }

    protected void initialize() {
        super.initialize();
        Log theLog = new Log(-86, 70, 0, "PA DOM ADD", null, null, null, null);
        String dataString = "added domain id=" + this.getDomainId().getDID();
        theLog.add((byte)3, dataString);
        theLog.log();
        int tempVal = this.dadData.getTimeoutValue("SynchronizationDelay");
        if (tempVal != -1) {
            this.setSynchDelay(tempVal);
        }
        if ((tempVal = this.dadData.getTimeoutValue("ProblemSynchronizationDelay")) != -1) {
            this.setProblemDataSynchDelay(tempVal);
        }
        if ((tempVal = this.dadData.getTimeoutValue("InitialDDEAnalysis")) != -1) {
            this.setInitialWait(tempVal);
        }
        MessageService.getMessageService().addREStateListener(this);
        this.initializeParticipants();
        if (this.synchronizeDuringInitialization()) {
            this.beginSynchronization();
        }
        if (this.synchronizeProblemDataDuringInitialization()) {
            this.beginProblemDataSynchronization(null);
        }
    }

    public void remove() {
        super.remove();
        MessageService.getMessageService().removeREStateListener(this);
        Log theLog = new Log(-86, 70, 0, "PA DOM REM", null, null, null, null);
        String dataString = "removed domain id=" + this.getDomainId().getDID();
        theLog.add((byte)3, dataString);
        theLog.log();
    }

    public void remoteSystemStateChanged(RemoteSystemStateEvent rsStateEvent) {
        if (!this.handleRSSEvent) {
            return;
        }
        RemoteSystem rs = rsStateEvent.getRemoteSystem();
        if (rs instanceof RemoteMachineSystem) {
            if (rsStateEvent.getState() == "Add") {
                this.remoteMachineAdd((RemoteMachineSystem)rs);
            } else if (rsStateEvent.getState() == "Remove") {
                this.remoteMachineRemove((RemoteMachineSystem)rs);
            }
        }
    }

    protected abstract void remoteMachineAdd(RemoteMachineSystem var1);

    protected abstract void remoteMachineRemove(RemoteMachineSystem var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitoredRemoteMachineSystems(Set rmsSet) {
        Set set = this.rmsSet;
        synchronized (set) {
            this.rmsSet = rmsSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getMonitoredRemoteMachineSystems() {
        Set set = this.rmsSet;
        synchronized (set) {
            return (Set)((HashSet)this.rmsSet).clone();
        }
    }

    protected void initializeParticipants() {
        Set reSet = MessageService.getMessageService().getAllAcceptingTargets(this.getDomainMessageId());
        this.handleRESEvent = true;
        Iterator reIter = reSet.iterator();
        RemoteEntity re = null;
        RemoteConsoleSystem rcs = null;
        while (reIter.hasNext()) {
            re = (RemoteEntity)reIter.next();
            if (re.getMTMS().equals(localConsole.getMTMS())) continue;
            rcs = new RemoteConsoleSystem(re);
            Trace.trace(TRACE_MASKF, this.getDomainTrace("adding console [" + rcs + "]"));
            try {
                this.addParticipant(rcs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void remoteEntityStateChanged(RemoteEntityStateEvent reStateEvent) {
        if (reStateEvent.getRemoteEntity().getMTMS().equals(localConsole.getMTMS())) {
            return;
        }
        if (!this.handleRESEvent) {
            return;
        }
        MessageId domMsgId = reStateEvent.getMessageId();
        if (!domMsgId.equals(this.getDomainMessageId())) {
            return;
        }
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> remoteEntityStateChanged:" + reStateEvent.getState()));
        if (reStateEvent.getState().equals("Add")) {
            this.remoteConsoleAdd(new RemoteConsoleSystem(reStateEvent.getRemoteEntity()));
        } else if (reStateEvent.getState().equals("Remove")) {
            this.remoteConsoleRemove(new RemoteConsoleSystem(reStateEvent.getRemoteEntity()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteConsoleAdd(RemoteConsoleSystem rcs) {
        if (this.getParticipants().contains(rcs)) {
            return;
        }
        Trace.trace(TRACE_MASKF, this.getDomainTrace("adding console [" + rcs + "]"));
        try {
            this.addParticipant(rcs);
        }
        catch (Exception e) {
            // empty catch block
        }
        Object object = this.synchDataLock;
        synchronized (object) {
            if (this.performingSynchronization) {
                this.addSynchData(rcs, null);
                boolean endPubLoop = false;
                while (!endPubLoop) {
                    try {
                        this.queuePublication(rcs, new PartitionedMessage(this.getDomainMessageId(), (Serializable)((Object)PART_DAD_WHOS_PRIME), null));
                        endPubLoop = true;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, this.getDomainTrace("couldn't publish primary request"));
                        Trace.trace(TRACE_MASKT, e);
                        if (this.isPublicationEnabled()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception te) {}
                            continue;
                        }
                        Trace.trace(TRACE_MASKD, "PA publication disabled - publication aborted");
                        endPubLoop = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteConsoleRemove(RemoteConsoleSystem rcs) {
        Trace.trace(TRACE_MASKF, this.getDomainTrace("removing console [" + rcs + "]"));
        this.removeParticipant(rcs);
        Object object = this.synchDataLock;
        synchronized (object) {
            this.removeSynchData(rcs);
        }
        PASystem primary = this.getPrimary();
        if (primary != null && primary.equals(rcs)) {
            this.setPrimary(null);
        }
    }

    public void setPrimary(PASystem primaryConsole) {
        String towerString = this.getDomainId().getDID() + ":";
        String dataString = "domain=" + this.getDomainId().getDID() + "; primary=";
        if (primaryConsole == null) {
            Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> setPrimary: null"));
            towerString = dataString.concat("null");
            dataString = dataString.concat("null");
        } else {
            Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> setPrimary: " + primaryConsole));
            towerString = dataString.concat(primaryConsole.toString());
            dataString = dataString.concat(primaryConsole.toString());
        }
        Log theLog = new Log(-86, 70, 0, "PA DOM PRM", null, null, null, towerString);
        theLog.add((byte)3, dataString);
        theLog.log();
        this.primaryConsole = primaryConsole;
    }

    public PASystem getPrimary() {
        return this.primaryConsole;
    }

    public boolean isPrimary() {
        PASystem primary = this.getPrimary();
        if (primary != null) {
            return primary instanceof ConsoleSystem;
        }
        return !this.isPublicationEnabled();
    }

    protected boolean synchronizeDuringInitialization() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSynchronization() {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("--> beginSynchronization"));
        int timerDelay = this.getSynchDelay();
        Object object = this.synchDataLock;
        synchronized (object) {
            if (this.performingSynchronization) {
                Trace.trace(TRACE_MASKD, "<-- beginSynchronization (already in progress)");
                return;
            }
            this.performingSynchronization = true;
            boolean endQueryLoop = false;
            while (!endQueryLoop) {
                this.resetSynchData();
                PASystem arbitorSystem = null;
                try {
                    arbitorSystem = this.getArbitrationLockHolder();
                }
                catch (LockAcquisitionException lae) {
                    // empty catch block
                }
                if (arbitorSystem instanceof ConsoleSystem) {
                    Trace.trace(TRACE_MASKD, "arbitor=local console");
                    if (this.getPrimary() == null) {
                        try {
                            this.releaseArbitrationLock();
                        }
                        catch (LockAcquisitionException lae) {}
                        continue;
                    }
                    endQueryLoop = true;
                    this.performingSynchronization = false;
                    this.resetSynchData();
                    continue;
                }
                if (arbitorSystem instanceof RemoteConsoleSystem) {
                    Trace.trace(TRACE_MASKD, "arbitor=" + arbitorSystem);
                    this.addSynchData(arbitorSystem, null);
                    try {
                        this.queuePublication((RemoteConsoleSystem)arbitorSystem, new PartitionedMessage(this.getDomainMessageId(), (Serializable)((Object)PART_DAD_WHOS_PRIME), null));
                        endQueryLoop = true;
                        continue;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, "couldn't publish primary request to arbitor");
                        Trace.trace(TRACE_MASKT, e);
                        if (PAPublication.isPublicationEnabled()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception te) {}
                            continue;
                        }
                        Trace.trace(TRACE_MASKD, "<-- beginSynchronization (PA publication disabled - synchronization aborted)");
                        this.performingSynchronization = false;
                        this.resetSynchData();
                        return;
                    }
                }
                if (arbitorSystem != null) continue;
                Trace.trace(TRACE_MASKD, "no arbitor");
                endQueryLoop = true;
                Set peerSet = this.getParticipants();
                if (peerSet == null || peerSet.isEmpty()) {
                    Trace.trace(TRACE_MASKD, "No arbitor, no peers - proceed to end of sync");
                    timerDelay = 0;
                    continue;
                }
                Iterator peerIter = peerSet.iterator();
                RemoteConsoleSystem peerSystem = null;
                boolean endPubLoop = false;
                while (peerIter.hasNext()) {
                    peerSystem = (RemoteConsoleSystem)peerIter.next();
                    this.addSynchData(peerSystem, null);
                    endPubLoop = false;
                    while (!endPubLoop) {
                        try {
                            this.queuePublication(peerSystem, new PartitionedMessage(this.getDomainMessageId(), (Serializable)((Object)PART_DAD_WHOS_PRIME), null));
                            endPubLoop = true;
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKT, "couldn't publish primary request");
                            Trace.trace(TRACE_MASKT, e);
                            if (this.isPublicationEnabled()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Exception te) {}
                                continue;
                            }
                            Trace.trace(TRACE_MASKD, "<-- beginSynchronization (PA publication disabled - synchronization aborted)");
                            this.performingSynchronization = false;
                            this.resetSynchData();
                            return;
                        }
                    }
                }
            }
            if (this.performingSynchronization) {
                Trace.trace(TRACE_MASKD, "Starting synchronization timer (" + timerDelay + " secs)");
                this.synchTimerTask = new CallbackTimerTask(this);
                this.synchTimerTask.schedule(timerDelay * 1000);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- beginSynchronization");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeSynchronization() {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("--> completeSynchronization"));
        Set primarySet = null;
        Object object = this.synchDataLock;
        synchronized (object) {
            if (!this.performingSynchronization) {
                Trace.trace(TRACE_MASKD, "<-- completeSynchronization (already completed)");
                return;
            }
            this.performingSynchronization = false;
            primarySet = this.getSynchDataSet();
        }
        if (primarySet == null || primarySet.size() != 1) {
            Trace.trace(TRACE_MASKF, "primary ambiguity - need to (re)arbitrate");
            try {
                this.acquireArbitrationLock();
            }
            catch (LockAcquisitionException lae) {
                Trace.trace(TRACE_MASKT, lae);
                Trace.trace(TRACE_MASKT, "<-- completeSynchronization (can't arbitrate - arbitration lock failure)");
                return;
            }
            catch (LockHeldException lhe) {
                Trace.trace(TRACE_MASKT, "<-- completeSynchronization (can't arbitrate - arbitration lock held)");
                this.beginSynchronization();
                return;
            }
            this.beginPrimaryArbitration();
            Trace.trace(TRACE_MASKD, "<-- completeSynchronization (began arbitration)");
            return;
        }
        String primaryMTMS = (String)primarySet.iterator().next();
        Trace.trace(TRACE_MASKD, "identified primary (" + primaryMTMS + ")");
        if (primaryMTMS == null || primaryMTMS.equals(UNKNOWN_PRIMARY)) {
            this.setPrimary(null);
            Trace.trace(TRACE_MASKT, "<-- completeSynchronization (null primary)");
            return;
        }
        this.setPrimary(this.convertMTMS(primaryMTMS));
        if (this.getPrimary() instanceof ConsoleSystem) {
            try {
                this.acquireArbitrationLock();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.isPrimaryAcceptible()) {
            Trace.trace(TRACE_MASKF, "primary contention - need to (re)arbitrate");
            PASystem currentPrimary = this.getPrimary();
            if (currentPrimary instanceof ConsoleSystem) {
                this.handleArbitrateRequest();
            } else {
                boolean endPubLoop = false;
                while (!endPubLoop) {
                    try {
                        this.queuePublication((RemoteConsoleSystem)currentPrimary, new PartitionedMessage(this.getDomainMessageId(), (Serializable)((Object)PART_DAD_ARBITRATE_REQUEST), null));
                        endPubLoop = true;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, "couldn't publish arbitration request");
                        Trace.trace(TRACE_MASKT, e);
                        if (this.isPublicationEnabled()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception te) {}
                            continue;
                        }
                        Trace.trace(TRACE_MASKD, "PA publication disabled - publication aborted (can't request arbitration)");
                        endPubLoop = true;
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<-- completeSynchronization");
    }

    protected void resetSynchData() {
        this.synchDataMap = new HashMap();
    }

    protected void addSynchData(PASystem synchSystem, Object synchData) {
        this.synchDataMap.put(synchSystem, synchData);
    }

    protected void removeSynchData(PASystem synchSystem) {
        this.synchDataMap.remove(synchSystem);
    }

    protected Object getSynchData(PASystem synchSystem) {
        return this.synchDataMap.get(synchSystem);
    }

    protected boolean hasSynchData(PASystem synchSystem) {
        return this.synchDataMap.containsKey(synchSystem);
    }

    protected Set getSynchSystemSet() {
        return this.synchDataMap.keySet();
    }

    protected Set getSynchDataSet() {
        HashSet dataSet = new HashSet();
        Collection dataCollection = this.synchDataMap.values();
        Iterator dataIter = dataCollection.iterator();
        while (dataIter.hasNext()) {
            dataSet.add(dataIter.next());
        }
        return dataSet;
    }

    public void timerPopped() {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> timerPopped"));
        this.completeSynchronization();
    }

    public void timerCancelled() {
    }

    protected void initiatePrimaryArbitration() {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("--> initiatePrimaryArbitration"));
        PASystem arbitorSystem = null;
        do {
            try {
                arbitorSystem = this.getArbitrationLockHolder();
            }
            catch (LockAcquisitionException lae) {
                Trace.trace(TRACE_MASKT, this.getDomainTrace("<-- initiatePrimaryArbitration - lock failure"));
                Trace.trace(TRACE_MASKT, lae);
                return;
            }
            if (arbitorSystem != null) continue;
            try {
                this.acquireArbitrationLock();
            }
            catch (LockAcquisitionException lae) {
                Trace.trace(TRACE_MASKT, this.getDomainTrace("<-- initiatePrimaryArbitration - lock failure"));
                Trace.trace(TRACE_MASKT, lae);
                return;
            }
            catch (LockHeldException lhe) {
                // empty catch block
            }
        } while (arbitorSystem == null);
        if (arbitorSystem instanceof ConsoleSystem) {
            this.beginPrimaryArbitration();
        } else {
            boolean endPubLoop = false;
            while (!endPubLoop) {
                try {
                    this.queuePublication((RemoteConsoleSystem)arbitorSystem, new PartitionedMessage(this.getDomainMessageId(), (Serializable)((Object)PART_DAD_ARBITRATE_COMMAND), null));
                    endPubLoop = true;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, this.getDomainTrace("couldn't publish arbitration command"));
                    Trace.trace(TRACE_MASKT, e);
                    if (PAPublication.isPublicationEnabled()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception te) {}
                        continue;
                    }
                    Trace.trace(TRACE_MASKD, "PA publication disabled - publication aborted");
                    endPubLoop = true;
                }
            }
        }
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-- initiatePrimaryArbitration"));
    }

    public abstract void beginPrimaryArbitration();

    protected abstract boolean isPrimaryAcceptible();

    protected abstract void acquireArbitrationLock() throws LockAcquisitionException, LockHeldException;

    protected abstract void releaseArbitrationLock() throws LockAcquisitionException;

    protected abstract PASystem getArbitrationLockHolder() throws LockAcquisitionException;

    protected boolean synchronizeProblemDataDuringInitialization() {
        return false;
    }

    public void beginProblemDataSynchronization(Set targetSystems) {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("Starting problem data synchronization thread (" + this.getProblemDataSynchDelay() + " secs)"));
        new ProblemDataSyncThread(this, targetSystems, this.getProblemDataSynchDelay()).start();
    }

    protected void handleMessage(PartitionedMessage msg, RemoteEntity sender2) {
        String partId = (String)((Object)msg.getPartition());
        RemoteConsoleSystem rcs = new RemoteConsoleSystem(sender2);
        if (partId.equals(PART_DAD_WHOS_PRIME)) {
            try {
                this.publishPrimaryData(rcs, (Serializable)((Object)PART_DAD_PRIME_INFO));
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, this.getDomainTrace("couldn't publish primary data to " + rcs));
                Trace.trace(TRACE_MASKT, e);
            }
        } else if (partId.equals(PART_DAD_PRIME_INFO)) {
            this.handlePrimeInfo(msg.getPayload(), rcs);
        } else if (partId.equals(PART_DAD_PRIME_UPDATE)) {
            this.handlePrimeUpdate(msg.getPayload(), rcs);
        } else if (partId.equals(PART_DAD_ARBITRATE_REQUEST)) {
            this.handleArbitrateRequest();
        } else if (partId.equals(PART_DAD_ARBITRATE_COMMAND)) {
            this.initiatePrimaryArbitration();
        } else if (partId.startsWith(PART_DAD_PROB_PREFIX)) {
            this.handleProblemAction(partId, (String)((Object)msg.getPayload()));
        } else {
            Trace.trace(TRACE_MASKT, this.getDomainTrace("Unknown partition type (" + partId + ") - discarding message"));
            return;
        }
    }

    protected void publishPrimaryData(RemoteConsoleSystem receiver, Serializable partition) throws HException {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> publishPrimaryData (to " + receiver + ")"));
        PASystem primary = this.getPrimary();
        String primaryInfo = null;
        primaryInfo = primary == null ? UNKNOWN_PRIMARY : primary.getMTMS();
        this.queuePublication(receiver, new PartitionedMessage(this.getDomainMessageId(), partition, (Serializable)((Object)primaryInfo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePrimeInfo(Object primeData, RemoteConsoleSystem sender2) {
        if (!(primeData instanceof String)) {
            Trace.trace(TRACE_MASKT, this.getDomainTrace("<-> handleprimeInfo: Unknown data type received (" + primeData.getClass().getName() + ").  Message discarded"));
            return;
        }
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> handlePrimeInfo (from " + sender2 + "; " + (String)primeData + ")"));
        Object object = this.synchDataLock;
        synchronized (object) {
            if (!this.performingSynchronization) {
                Trace.trace(TRACE_MASKT, this.getDomainTrace("<-> handlePrimeInfo: Not synchronizing.  Message discarded"));
                return;
            }
            this.addSynchData(sender2, primeData);
            boolean gotAll = true;
            Iterator peerIter = this.getSynchSystemSet().iterator();
            while (peerIter.hasNext()) {
                if (this.getSynchData((PASystem)peerIter.next()) != null) continue;
                gotAll = false;
                break;
            }
            if (gotAll) {
                Trace.trace(TRACE_MASKD, "got all expected peer responses - cancelling synchronization timer");
                this.synchTimerTask.cancel();
                this.completeSynchronization();
            }
        }
    }

    protected void handlePrimeUpdate(Object primeData, RemoteConsoleSystem sender2) {
        if (!(primeData instanceof String)) {
            Trace.trace(TRACE_MASKT, this.getDomainTrace("<-> handlePrimeUpdate: Unknown data type received (" + primeData.getClass().getName() + ").  Message discarded"));
            return;
        }
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> handlePrimeUpdate (from " + sender2 + "; " + (String)primeData + ")"));
        PASystem newPrimary = this.convertMTMS((String)primeData);
        PASystem origPrimary = this.getPrimary();
        if (origPrimary == null && newPrimary != null || origPrimary != null && newPrimary == null || !origPrimary.equals(newPrimary)) {
            this.primaryChanged(newPrimary);
        } else {
            this.setPrimary(newPrimary);
        }
    }

    protected PASystem convertMTMS(String consoleMTMS) {
        if (localConsole != null && localConsole.getMTMS().equals(consoleMTMS)) {
            return localConsole;
        }
        Iterator peerIterator = this.getParticipants().iterator();
        RemoteConsoleSystem peerSys = null;
        while (peerIterator.hasNext()) {
            peerSys = (RemoteConsoleSystem)peerIterator.next();
            if (!peerSys.getMTMS().equals(consoleMTMS)) continue;
            return peerSys;
        }
        RemoteConsoleSystem unknownSystem = new RemoteConsoleSystem();
        unknownSystem.setMachineType(PASystem.extractMachineType(consoleMTMS));
        unknownSystem.setMachineModel(PASystem.extractMachineModel(consoleMTMS));
        unknownSystem.setMachineSerial(PASystem.extractMachineSerial(consoleMTMS));
        unknownSystem.setSystemName(unknownSystem.getMTMS());
        return unknownSystem;
    }

    protected void primaryChanged(PASystem newPrimary) {
        this.setPrimary(newPrimary);
        this.reservationsExist(true);
    }

    protected void handleArbitrateRequest() {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("<-> handleArbitrateRequest"));
        if (!this.reservationsExist(false)) {
            this.initiatePrimaryArbitration();
        } else {
            ReservationManager.getReservationManager().addListener(this);
        }
    }

    private boolean reservationsExist(boolean forceRelease) {
        Iterator reservations = ReservationManager.getReservationManager().reservationKeyIterator();
        String reservationKey = null;
        boolean foundReservation = false;
        while (reservations.hasNext()) {
            reservationKey = (String)reservations.next();
            if (!reservationKey.startsWith(this.getDomainReservationKey())) continue;
            foundReservation = true;
            if (!forceRelease) break;
            ReservationManager.getReservationManager().force(reservationKey);
        }
        return foundReservation;
    }

    public void obtained(ReservationManagerEvent event) {
    }

    public void released(ReservationManagerEvent event) {
        if (!this.reservationsExist(false)) {
            ReservationManager.getReservationManager().removeListener(this);
            this.initiatePrimaryArbitration();
        }
    }

    public void forced(ReservationManagerEvent event) {
    }

    public static boolean attemptProblemActionRedirection(CommonProblem problem, String action) {
        Domain probDom = problem.getDomain();
        if (probDom == null || !(probDom instanceof DistributedAnalysisDomain)) {
            Trace.trace(TRACE_MASKF, "redirection not possible (no domain) or unnecessary (not distributed)");
            return false;
        }
        DistributedAnalysisDomain dad = (DistributedAnalysisDomain)probDom;
        PASystem primary = dad.getPrimary();
        if (primary instanceof ConsoleSystem) {
            Trace.trace(TRACE_MASKF, "redirection unnecessary - we're primary");
            return false;
        }
        Trace.trace(TRACE_MASKF, "redirecting to primary console");
        try {
            dad.queuePublication((RemoteConsoleSystem)primary, new PartitionedMessage(dad.getDomainMessageId(), (Serializable)((Object)action), (Serializable)((Object)problem.getUniqueKey())));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "redirection failed - exception");
            Trace.trace(TRACE_MASKF, e);
            return false;
        }
        return true;
    }

    protected void handleProblemAction(String action, String probKey) {
        Trace.trace(TRACE_MASKD, this.getDomainTrace("--> handleProblemAction (action=" + action + ",prob key=" + probKey + ")"));
        Problem prob = null;
        try {
            prob = ProblemManager.getProblemManager().getProblem(probKey);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- handleProblemAction: Exception during problem search");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        if (prob == null) {
            Trace.trace(TRACE_MASKD, "<-- handleProblemAction: could not find problem for key=" + probKey);
            return;
        }
        if (action.equals(PART_DAD_PROB_SVC_AUTH)) {
            ((CommonProblem)prob).primaryServiceAuthorized();
        } else if (action.equals(PART_DAD_PROB_SVC_DECL)) {
            ((CommonProblem)prob).primaryServiceDeclined();
        } else if (action.equals(PART_DAD_PROB_SVC_MAN)) {
            ((CommonProblem)prob).primaryServiceManual();
        } else if (action.equals(PART_DAD_PROB_CLOSE)) {
            try {
                ProblemManager.getProblemManager().primaryClose(prob);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "<-- handleProblemAction: Exception during problem close");
                Trace.trace(TRACE_MASKT, e);
                return;
            }
        }
        Trace.trace(TRACE_MASKD, "<-- handleProblemAction");
    }

    public ProblemAnalysisEventManager getEventManager() {
        return this.evtMgr;
    }

    public void setEventManager(ProblemAnalysisEventManager evtMgr) {
        this.evtMgr = evtMgr;
    }

    public int getSynchDelay() {
        return this.synchDelay;
    }

    public void setSynchDelay(int waitVal) {
        this.synchDelay = waitVal;
    }

    public int getProblemDataSynchDelay() {
        return this.problemDataSynchDelay;
    }

    public void setProblemDataSynchDelay(int waitVal) {
        this.problemDataSynchDelay = waitVal;
    }

    public int getInitialWait() {
        return this.initialWait;
    }

    public void setInitialWait(int waitVal) {
        this.initialWait = waitVal;
    }

    public CommonServiceAREvent getInitialTimeoutEvent(Object source) {
        return new InitialDDETimeoutEvent(source);
    }

    public abstract AnalysisDomainAnalysisEvent getSystemAnalysisEvent(Object var1);

    public String getDomainReservationKey() {
        return this.getDomainId().getDID();
    }

    public String getDomainReservationKey(int problemNumber) {
        return this.getDomainReservationKey() + "_" + Integer.toString(problemNumber);
    }

    public boolean isPublicationEnabled() {
        return PAPublication.isPublicationEnabled();
    }
}

